-- MySQL dump 10.13  Distrib 8.0.39, for Linux (x86_64)
--
-- Host: localhost    Database: APPM_DB
-- ------------------------------------------------------
-- Server version	8.0.39-0ubuntu0.20.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AP_APP`
--

DROP TABLE IF EXISTS `AP_APP`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(350) NOT NULL,
  `DESCRIPTION` varchar(200) NOT NULL,
  `TYPE` varchar(200) NOT NULL,
  `TENANT_ID` int NOT NULL,
  `STATUS` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  `SUB_TYPE` varchar(45) NOT NULL,
  `CURRENCY` varchar(45) DEFAULT '$',
  `RATING` double DEFAULT NULL,
  `DEVICE_TYPE_ID` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP`
--

LOCK TABLES `AP_APP` WRITE;
/*!40000 ALTER TABLE `AP_APP` DISABLE KEYS */;
INSERT INTO `AP_APP` VALUES (1,'Calculator App','Calculator app','ENTERPRISE',1,'ACTIVE','FREE','$',NULL,1),(2,'Calculator','Calculator','ENTERPRISE',-1234,'ACTIVE','FREE','$',NULL,1),(3,'New Calculator','New Calculator','ENTERPRISE',-1234,'ACTIVE','FREE','$',NULL,1),(5,'test app entgra','calculator','ENTERPRISE',1,'ACTIVE','FREE','$',NULL,1),(6,'web app','web app','WEB_CLIP',-1234,'ACTIVE','FREE','$',NULL,0);
/*!40000 ALTER TABLE `AP_APP` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_CATEGORY`
--

DROP TABLE IF EXISTS `AP_APP_CATEGORY`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_CATEGORY` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `CATEGORY` varchar(45) NOT NULL,
  `CATEGORY_ICON` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_CATEGORY`
--

LOCK TABLES `AP_APP_CATEGORY` WRITE;
/*!40000 ALTER TABLE `AP_APP_CATEGORY` DISABLE KEYS */;
INSERT INTO `AP_APP_CATEGORY` VALUES (1,-1234,'EMM',NULL),(2,-1234,'IoT',NULL),(3,-1234,'Art & Design',NULL),(4,-1234,'Auto & Vehicles',NULL),(5,-1234,'Beauty',NULL),(6,-1234,'Books & Reference',NULL),(7,-1234,'Business',NULL),(8,-1234,'Comics',NULL),(9,-1234,'Communications',NULL),(10,-1234,'Dating',NULL),(11,-1234,'Education',NULL),(12,-1234,'Entertainment',NULL),(13,-1234,'Events',NULL),(14,-1234,'Finance',NULL),(15,-1234,'Food & Drink',NULL),(16,-1234,'Health & Fitness',NULL),(17,-1234,'House & Home',NULL),(18,-1234,'Libraries & Demo',NULL),(19,-1234,'Lifestyle',NULL),(20,-1234,'Maps & Navigation',NULL),(21,-1234,'Medical',NULL),(22,-1234,'Music & Audio',NULL),(23,-1234,'News & Magazines',NULL),(24,-1234,'Parenting',NULL),(25,-1234,'Personalization',NULL),(26,-1234,'Photography',NULL),(27,-1234,'Productivity',NULL),(28,-1234,'Shopping',NULL),(29,-1234,'Social',NULL),(30,-1234,'Sports',NULL),(31,-1234,'Tools',NULL),(32,-1234,'Travel & Local',NULL),(33,-1234,'Video Players & Editors',NULL),(34,-1234,'Weather',NULL),(35,-1234,'GooglePlaySyncedApp',NULL),(36,-1234,'AppleStoreSyncedApp',NULL),(37,1,'EMM',NULL),(38,1,'IoT',NULL),(39,1,'Art & Design',NULL),(40,1,'Auto & Vehicles',NULL),(41,1,'Beauty',NULL),(42,1,'Books & Reference',NULL),(43,1,'Business',NULL),(44,1,'Comics',NULL),(45,1,'Communications',NULL),(46,1,'Dating',NULL),(47,1,'Education',NULL),(48,1,'Entertainment',NULL),(49,1,'Events',NULL),(50,1,'Finance',NULL),(51,1,'Food & Drink',NULL),(52,1,'Health & Fitness',NULL),(53,1,'House & Home',NULL),(54,1,'Libraries & Demo',NULL),(55,1,'Lifestyle',NULL),(56,1,'Maps & Navigation',NULL),(57,1,'Medical',NULL),(58,1,'Music & Audio',NULL),(59,1,'News & Magazines',NULL),(60,1,'Parenting',NULL),(61,1,'Personalization',NULL),(62,1,'Photography',NULL),(63,1,'Productivity',NULL),(64,1,'Shopping',NULL),(65,1,'Social',NULL),(66,1,'Sports',NULL),(67,1,'Tools',NULL),(68,1,'Travel & Local',NULL),(69,1,'Video Players & Editors',NULL),(70,1,'Weather',NULL),(71,1,'GooglePlaySyncedApp',NULL),(72,1,'AppleStoreSyncedApp',NULL);
/*!40000 ALTER TABLE `AP_APP_CATEGORY` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_CATEGORY_MAPPING`
--

DROP TABLE IF EXISTS `AP_APP_CATEGORY_MAPPING`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_CATEGORY_MAPPING` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `AP_APP_CATEGORY_ID` int NOT NULL,
  `AP_APP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_CATEGORY_copy1_AP_APP_CATEGORY1_idx` (`AP_APP_CATEGORY_ID`),
  KEY `fk_AP_APP_CATEGORY_copy1_AP_APP1_idx` (`AP_APP_ID`),
  CONSTRAINT `fk_AP_APP_CATEGORY_copy1_AP_APP1` FOREIGN KEY (`AP_APP_ID`) REFERENCES `AP_APP` (`ID`),
  CONSTRAINT `fk_AP_APP_CATEGORY_copy1_AP_APP_CATEGORY1` FOREIGN KEY (`AP_APP_CATEGORY_ID`) REFERENCES `AP_APP_CATEGORY` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_CATEGORY_MAPPING`
--

LOCK TABLES `AP_APP_CATEGORY_MAPPING` WRITE;
/*!40000 ALTER TABLE `AP_APP_CATEGORY_MAPPING` DISABLE KEYS */;
INSERT INTO `AP_APP_CATEGORY_MAPPING` VALUES (1,1,37,1),(2,-1234,1,2),(3,-1234,2,2),(4,-1234,1,3),(6,1,37,5),(7,1,38,5),(8,-1234,1,6);
/*!40000 ALTER TABLE `AP_APP_CATEGORY_MAPPING` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_FAVOURITES`
--

DROP TABLE IF EXISTS `AP_APP_FAVOURITES`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_FAVOURITES` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `AP_APP_ID` int NOT NULL,
  `USER_NAME` varchar(100) NOT NULL,
  `TENANT_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `AP_APP_FAVOURITES_AP_APP_ID_fk` (`AP_APP_ID`),
  CONSTRAINT `AP_APP_FAVOURITES_AP_APP_ID_fk` FOREIGN KEY (`AP_APP_ID`) REFERENCES `AP_APP` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_FAVOURITES`
--

LOCK TABLES `AP_APP_FAVOURITES` WRITE;
/*!40000 ALTER TABLE `AP_APP_FAVOURITES` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_APP_FAVOURITES` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_LIFECYCLE_STATE`
--

DROP TABLE IF EXISTS `AP_APP_LIFECYCLE_STATE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_LIFECYCLE_STATE` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CURRENT_STATE` varchar(45) NOT NULL,
  `PREVIOUS_STATE` varchar(45) NOT NULL,
  `TENANT_ID` int NOT NULL,
  `UPDATED_BY` varchar(100) NOT NULL,
  `UPDATED_AT` bigint NOT NULL,
  `AP_APP_RELEASE_ID` int NOT NULL,
  `REASON` text,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_LIFECYCLE_STATE_AP_APP_RELEASE1_idx` (`AP_APP_RELEASE_ID`),
  CONSTRAINT `fk_AP_APP_LIFECYCLE_STATE_AP_APP_RELEASE1` FOREIGN KEY (`AP_APP_RELEASE_ID`) REFERENCES `AP_APP_RELEASE` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_LIFECYCLE_STATE`
--

LOCK TABLES `AP_APP_LIFECYCLE_STATE` WRITE;
/*!40000 ALTER TABLE `AP_APP_LIFECYCLE_STATE` DISABLE KEYS */;
INSERT INTO `AP_APP_LIFECYCLE_STATE` VALUES (1,'CREATED','CREATED',1,'admin',1727091144,1,NULL),(2,'IN-REVIEW','CREATED',1,'admin',1727091144,1,'Updated to IN-REVIEW'),(3,'APPROVED','IN-REVIEW',1,'admin',1727091144,1,'Updated to APPROVED'),(4,'PUBLISHED','APPROVED',1,'admin',1727091144,1,'Updated to PUBLISHED'),(5,'CREATED','CREATED',-1234,'admin',1727097885,2,NULL),(6,'IN-REVIEW','CREATED',-1234,'admin',1727097885,2,'Updated to IN-REVIEW'),(7,'APPROVED','IN-REVIEW',-1234,'admin',1727097885,2,'Updated to APPROVED'),(8,'PUBLISHED','APPROVED',-1234,'admin',1727097885,2,'Updated to PUBLISHED'),(9,'CREATED','CREATED',-1234,'admin',1727146897,3,NULL),(10,'IN-REVIEW','CREATED',-1234,'admin',1727146897,3,'Updated to IN-REVIEW'),(11,'APPROVED','IN-REVIEW',-1234,'admin',1727146897,3,'Updated to APPROVED'),(12,'PUBLISHED','APPROVED',-1234,'admin',1727146897,3,'Updated to PUBLISHED'),(14,'CREATED','CREATED',-1234,'admin',1727151424,5,NULL),(15,'IN-REVIEW','CREATED',-1234,'admin',1727151424,5,'Updated to IN-REVIEW'),(16,'APPROVED','IN-REVIEW',-1234,'admin',1727151424,5,'Updated to APPROVED'),(17,'PUBLISHED','APPROVED',-1234,'admin',1727151424,5,'Updated to PUBLISHED');
/*!40000 ALTER TABLE `AP_APP_LIFECYCLE_STATE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_RELEASE`
--

DROP TABLE IF EXISTS `AP_APP_RELEASE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_RELEASE` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DESCRIPTION` text NOT NULL,
  `VERSION` varchar(70) NOT NULL,
  `TENANT_ID` int NOT NULL,
  `UUID` varchar(200) NOT NULL,
  `RELEASE_TYPE` varchar(45) NOT NULL,
  `PACKAGE_NAME` varchar(150) NOT NULL,
  `APP_PRICE` decimal(6,2) DEFAULT NULL,
  `INSTALLER_LOCATION` varchar(100) NOT NULL,
  `ICON_LOCATION` varchar(100) NOT NULL,
  `BANNER_LOCATION` varchar(100) DEFAULT NULL,
  `SC_1_LOCATION` varchar(100) NOT NULL,
  `SC_2_LOCATION` varchar(100) DEFAULT NULL,
  `SC_3_LOCATION` varchar(100) DEFAULT NULL,
  `APP_HASH_VALUE` varchar(1000) NOT NULL,
  `SHARED_WITH_ALL_TENANTS` tinyint(1) NOT NULL DEFAULT '0',
  `APP_META_INFO` text,
  `SUPPORTED_OS_VERSIONS` varchar(45) NOT NULL,
  `RATING` double DEFAULT NULL,
  `CURRENT_STATE` varchar(45) NOT NULL,
  `RATED_USERS` int DEFAULT NULL,
  `AP_APP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_RELEASE_AP_APP1_idx` (`AP_APP_ID`),
  CONSTRAINT `fk_AP_APP_RELEASE_AP_APP1` FOREIGN KEY (`AP_APP_ID`) REFERENCES `AP_APP` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_RELEASE`
--

LOCK TABLES `AP_APP_RELEASE` WRITE;
/*!40000 ALTER TABLE `AP_APP_RELEASE` DISABLE KEYS */;
INSERT INTO `AP_APP_RELEASE` VALUES (1,'Stable release','2.4.1',1,'b6e64349-1a84-4243-8fc8-f9416194ce02','Stable release','com.gigaworks.tech.calculator',0.00,'Calculator Plus_2.4.1_APKPure.apk','icon.webp',NULL,'Cal1.webp','Cal2.webp','Cal3.webp','f8839d7e82601c78db668e3ca9658bb6',0,'[]','1-35',NULL,'PUBLISHED',NULL,1),(2,'Stable release','2.4.1',-1234,'89c92cf6-fd05-4e63-a539-06ad6d8dc849','Stable release','com.gigaworks.tech.calculator',0.00,'Calculator Plus_2.4.1_APKPure.apk','icon.webp',NULL,'Cal1.webp','Cal2.webp','Cal3.webp','f8839d7e82601c78db668e3ca9658bb6',0,'[]','1-35',NULL,'PUBLISHED',NULL,2),(3,'Stable release','12.1.20.3',-1234,'49c2ff75-e43e-4892-9b47-222aefec1035','Stable release','com.sec.android.app.popupcalculator',0.00,'Samsung_Calculator_12.1.20.3_Apkpure.apk','icon.webp',NULL,'Cal1.webp','Cal2.webp','Cal3.webp','d8b08e1f6df02ab268170ce012c232d7',0,'[]','1-35',NULL,'PUBLISHED',NULL,3),(5,'Stable release','v1.0',-1234,'37a7763c-67c3-48b8-93b1-005cc7070ac8','Stable release','default.app.com',0.00,'https://www.engineeringpublish.com','icon.png',NULL,'Entgra.jpeg','Entgraicon1.png','Entgraicon3.png','57923d2c731248dc10a42896e9b08f83',0,'[]','ANY',NULL,'PUBLISHED',NULL,6);
/*!40000 ALTER TABLE `AP_APP_RELEASE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_REVIEW`
--

DROP TABLE IF EXISTS `AP_APP_REVIEW`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_REVIEW` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `COMMENT` text NOT NULL,
  `ROOT_PARENT_ID` int NOT NULL,
  `IMMEDIATE_PARENT_ID` int NOT NULL,
  `CREATED_AT` bigint NOT NULL,
  `MODIFIED_AT` bigint NOT NULL,
  `RATING` int DEFAULT NULL,
  `USERNAME` varchar(45) NOT NULL,
  `ACTIVE_REVIEW` tinyint(1) NOT NULL DEFAULT '1',
  `AP_APP_RELEASE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_COMMENT_AP_APP_RELEASE1_idx` (`AP_APP_RELEASE_ID`),
  CONSTRAINT `fk_AP_APP_COMMENT_AP_APP_RELEASE1` FOREIGN KEY (`AP_APP_RELEASE_ID`) REFERENCES `AP_APP_RELEASE` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_REVIEW`
--

LOCK TABLES `AP_APP_REVIEW` WRITE;
/*!40000 ALTER TABLE `AP_APP_REVIEW` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_APP_REVIEW` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_SUB_OP_MAPPING`
--

DROP TABLE IF EXISTS `AP_APP_SUB_OP_MAPPING`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_SUB_OP_MAPPING` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `OPERATION_ID` int NOT NULL,
  `AP_DEVICE_SUBSCRIPTION_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_SUB_OP_MAPPING_AP_DEVICE_SUBSCRIPTION1_idx` (`AP_DEVICE_SUBSCRIPTION_ID`),
  CONSTRAINT `fk_AP_APP_SUB_OP_MAPPING_AP_DEVICE_SUBSCRIPTION1` FOREIGN KEY (`AP_DEVICE_SUBSCRIPTION_ID`) REFERENCES `AP_DEVICE_SUBSCRIPTION` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_SUB_OP_MAPPING`
--

LOCK TABLES `AP_APP_SUB_OP_MAPPING` WRITE;
/*!40000 ALTER TABLE `AP_APP_SUB_OP_MAPPING` DISABLE KEYS */;
INSERT INTO `AP_APP_SUB_OP_MAPPING` VALUES (1,1,228,1),(2,1,228,2),(3,1,228,3),(4,1,228,4),(5,1,228,5),(6,1,228,6),(7,1,228,7),(8,1,228,8),(9,1,228,9),(10,1,229,10),(11,-1234,384,11),(12,-1234,384,12),(13,-1234,387,11),(14,-1234,397,12),(15,-1234,623,13);
/*!40000 ALTER TABLE `AP_APP_SUB_OP_MAPPING` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_TAG`
--

DROP TABLE IF EXISTS `AP_APP_TAG`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_TAG` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `TAG` varchar(100) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_TAG`
--

LOCK TABLES `AP_APP_TAG` WRITE;
/*!40000 ALTER TABLE `AP_APP_TAG` DISABLE KEYS */;
INSERT INTO `AP_APP_TAG` VALUES (1,1,'Enterprise App'),(2,-1234,'Enterprise app'),(3,-1234,'Public App'),(4,-1234,'Web App');
/*!40000 ALTER TABLE `AP_APP_TAG` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_APP_TAG_MAPPING`
--

DROP TABLE IF EXISTS `AP_APP_TAG_MAPPING`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_APP_TAG_MAPPING` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `AP_APP_TAG_ID` int NOT NULL,
  `AP_APP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_TAG_copy1_AP_APP_TAG1_idx` (`AP_APP_TAG_ID`),
  KEY `fk_AP_APP_TAG_copy1_AP_APP1_idx` (`AP_APP_ID`),
  CONSTRAINT `fk_AP_APP_TAG_copy1_AP_APP1` FOREIGN KEY (`AP_APP_ID`) REFERENCES `AP_APP` (`ID`),
  CONSTRAINT `fk_AP_APP_TAG_copy1_AP_APP_TAG1` FOREIGN KEY (`AP_APP_TAG_ID`) REFERENCES `AP_APP_TAG` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_APP_TAG_MAPPING`
--

LOCK TABLES `AP_APP_TAG_MAPPING` WRITE;
/*!40000 ALTER TABLE `AP_APP_TAG_MAPPING` DISABLE KEYS */;
INSERT INTO `AP_APP_TAG_MAPPING` VALUES (1,1,1,1),(2,-1234,2,2),(3,-1234,2,3),(5,1,1,5),(6,-1234,4,6);
/*!40000 ALTER TABLE `AP_APP_TAG_MAPPING` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_ASSETS`
--

DROP TABLE IF EXISTS `AP_ASSETS`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_ASSETS` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `APP_ID` int DEFAULT NULL,
  `TENANT_ID` int NOT NULL,
  `CREATED_TIME` bigint DEFAULT NULL,
  `LAST_UPDATED_TIME` bigint DEFAULT NULL,
  `ADAM_ID` varchar(255) DEFAULT NULL,
  `ASSIGNED_COUNT` varchar(255) DEFAULT NULL,
  `DEVICE_ASSIGNABLE` varchar(255) DEFAULT NULL,
  `PRICING_PARAMS` varchar(255) DEFAULT NULL,
  `PRODUCT_TYPE` varchar(255) DEFAULT NULL,
  `RETIRED_COUNT` varchar(255) DEFAULT NULL,
  `REVOCABLE` varchar(255) DEFAULT NULL,
  `SUPPORTED_PLATFORMS` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_ASSETS`
--

LOCK TABLES `AP_ASSETS` WRITE;
/*!40000 ALTER TABLE `AP_ASSETS` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_ASSETS` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_DEVICE_SUBSCRIPTION`
--

DROP TABLE IF EXISTS `AP_DEVICE_SUBSCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_DEVICE_SUBSCRIPTION` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `SUBSCRIBED_BY` varchar(100) NOT NULL,
  `SUBSCRIBED_TIMESTAMP` timestamp NOT NULL,
  `UNSUBSCRIBED` tinyint(1) NOT NULL DEFAULT '0',
  `UNSUBSCRIBED_BY` varchar(100) DEFAULT NULL,
  `UNSUBSCRIBED_TIMESTAMP` timestamp NULL DEFAULT NULL,
  `ACTION_TRIGGERED_FROM` varchar(45) NOT NULL,
  `STATUS` varchar(45) NOT NULL,
  `DM_DEVICE_ID` int NOT NULL,
  `AP_APP_RELEASE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `uq_AP_DEVICE_SUBSCRIPTION` (`DM_DEVICE_ID`,`AP_APP_RELEASE_ID`),
  KEY `fk_AP_DEVICE_SUBSCRIPTION_AP_APP_RELEASE1_idx` (`AP_APP_RELEASE_ID`),
  CONSTRAINT `fk_AP_DEVICE_SUBSCRIPTION_AP_APP_RELEASE1` FOREIGN KEY (`AP_APP_RELEASE_ID`) REFERENCES `AP_APP_RELEASE` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_DEVICE_SUBSCRIPTION`
--

LOCK TABLES `AP_DEVICE_SUBSCRIPTION` WRITE;
/*!40000 ALTER TABLE `AP_DEVICE_SUBSCRIPTION` DISABLE KEYS */;
INSERT INTO `AP_DEVICE_SUBSCRIPTION` VALUES (1,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','ERROR',5,1),(2,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',6,1),(3,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',7,1),(4,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',9,1),(5,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',3,1),(6,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',4,1),(7,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',8,1),(8,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',11,1),(9,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'group','PENDING',10,1),(10,1,'admin','2024-09-23 11:44:39',0,NULL,NULL,'DEVICE','PENDING',12,1),(11,-1234,'admin','2024-09-23 13:27:17',0,NULL,NULL,'DEVICE','ERROR',2,2),(12,-1234,'admin','2024-09-23 13:30:52',0,NULL,NULL,'group','ERROR',1,2),(13,-1234,'admin','2024-09-24 03:01:59',0,NULL,NULL,'DEVICE','COMPLETED',2,3);
/*!40000 ALTER TABLE `AP_DEVICE_SUBSCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_GROUP_SUBSCRIPTION`
--

DROP TABLE IF EXISTS `AP_GROUP_SUBSCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_GROUP_SUBSCRIPTION` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `SUBSCRIBED_BY` varchar(100) NOT NULL,
  `SUBSCRIBED_TIMESTAMP` timestamp NOT NULL,
  `UNSUBSCRIBED` tinyint(1) NOT NULL DEFAULT '0',
  `UNSUBSCRIBED_BY` varchar(100) DEFAULT NULL,
  `UNSUBSCRIBED_TIMESTAMP` timestamp NULL DEFAULT NULL,
  `GROUP_NAME` varchar(100) NOT NULL,
  `AP_APP_RELEASE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_GROUP_SUBSCRIPTION_AP_APP_RELEASE1_idx` (`AP_APP_RELEASE_ID`),
  CONSTRAINT `fk_AP_GROUP_SUBSCRIPTION_AP_APP_RELEASE1` FOREIGN KEY (`AP_APP_RELEASE_ID`) REFERENCES `AP_APP_RELEASE` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_GROUP_SUBSCRIPTION`
--

LOCK TABLES `AP_GROUP_SUBSCRIPTION` WRITE;
/*!40000 ALTER TABLE `AP_GROUP_SUBSCRIPTION` DISABLE KEYS */;
INSERT INTO `AP_GROUP_SUBSCRIPTION` VALUES (1,1,'admin','2024-09-23 11:44:14',0,NULL,NULL,'COPE',1),(2,-1234,'admin','2024-09-23 13:30:52',0,NULL,NULL,'BYOD',2);
/*!40000 ALTER TABLE `AP_GROUP_SUBSCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_IDENTITY_SERVER`
--

DROP TABLE IF EXISTS `AP_IDENTITY_SERVER`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_IDENTITY_SERVER` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(255) NOT NULL,
  `DESCRIPTION` varchar(255) NOT NULL,
  `PROVIDER_NAME` varchar(255) NOT NULL,
  `URL` varchar(255) NOT NULL,
  `API_PARAMS` text NOT NULL,
  `USERNAME` varchar(255) NOT NULL,
  `PASSWORD` varchar(255) NOT NULL,
  `TENANT_ID` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_IDENTITY_SERVER`
--

LOCK TABLES `AP_IDENTITY_SERVER` WRITE;
/*!40000 ALTER TABLE `AP_IDENTITY_SERVER` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_IDENTITY_SERVER` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_IS_SP_APP_MAPPING`
--

DROP TABLE IF EXISTS `AP_IS_SP_APP_MAPPING`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_IS_SP_APP_MAPPING` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SP_UID` varchar(255) NOT NULL,
  `AP_APP_ID` int NOT NULL,
  `IS_ID` int NOT NULL,
  `TENANT_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `AP_IS_SP_APP_MAPPING_AP_APP_ID_fk` (`AP_APP_ID`),
  KEY `AP_IS_SP_APP_MAPPING_AP_IDENTITY_SERVER_ID_fk` (`IS_ID`),
  CONSTRAINT `AP_IS_SP_APP_MAPPING_AP_APP_ID_fk` FOREIGN KEY (`AP_APP_ID`) REFERENCES `AP_APP` (`ID`),
  CONSTRAINT `AP_IS_SP_APP_MAPPING_AP_IDENTITY_SERVER_ID_fk` FOREIGN KEY (`IS_ID`) REFERENCES `AP_IDENTITY_SERVER` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_IS_SP_APP_MAPPING`
--

LOCK TABLES `AP_IS_SP_APP_MAPPING` WRITE;
/*!40000 ALTER TABLE `AP_IS_SP_APP_MAPPING` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_IS_SP_APP_MAPPING` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_ROLE_SUBSCRIPTION`
--

DROP TABLE IF EXISTS `AP_ROLE_SUBSCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_ROLE_SUBSCRIPTION` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `ROLE_NAME` varchar(100) NOT NULL,
  `SUBSCRIBED_BY` varchar(100) NOT NULL,
  `SUBSCRIBED_TIMESTAMP` timestamp NOT NULL,
  `UNSUBSCRIBED` tinyint(1) NOT NULL DEFAULT '0',
  `UNSUBSCRIBED_BY` varchar(100) DEFAULT NULL,
  `UNSUBSCRIBED_TIMESTAMP` timestamp NULL DEFAULT NULL,
  `AP_APP_RELEASE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_ROLE_SUBSCRIPTION_AP_APP_RELEASE1_idx` (`AP_APP_RELEASE_ID`),
  CONSTRAINT `fk_AP_ROLE_SUBSCRIPTION_AP_APP_RELEASE1` FOREIGN KEY (`AP_APP_RELEASE_ID`) REFERENCES `AP_APP_RELEASE` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_ROLE_SUBSCRIPTION`
--

LOCK TABLES `AP_ROLE_SUBSCRIPTION` WRITE;
/*!40000 ALTER TABLE `AP_ROLE_SUBSCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_ROLE_SUBSCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_SCHEDULED_SUBSCRIPTION`
--

DROP TABLE IF EXISTS `AP_SCHEDULED_SUBSCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_SCHEDULED_SUBSCRIPTION` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TASK_NAME` varchar(100) NOT NULL,
  `APPLICATION_UUID` varchar(36) NOT NULL,
  `SUBSCRIBER_LIST` text NOT NULL,
  `STATUS` varchar(15) NOT NULL,
  `SCHEDULED_AT` bigint NOT NULL,
  `SCHEDULED_BY` varchar(100) NOT NULL,
  `SCHEDULED_TIMESTAMP` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DELETED` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_SCHEDULED_SUBSCRIPTION`
--

LOCK TABLES `AP_SCHEDULED_SUBSCRIPTION` WRITE;
/*!40000 ALTER TABLE `AP_SCHEDULED_SUBSCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_SCHEDULED_SUBSCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_UNRESTRICTED_ROLE`
--

DROP TABLE IF EXISTS `AP_UNRESTRICTED_ROLE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_UNRESTRICTED_ROLE` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `ROLE` varchar(45) NOT NULL,
  `AP_APP_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_APP_VISIBILITY_AP_APP1_idx` (`AP_APP_ID`),
  CONSTRAINT `fk_AP_APP_VISIBILITY_AP_APP1` FOREIGN KEY (`AP_APP_ID`) REFERENCES `AP_APP` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_UNRESTRICTED_ROLE`
--

LOCK TABLES `AP_UNRESTRICTED_ROLE` WRITE;
/*!40000 ALTER TABLE `AP_UNRESTRICTED_ROLE` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_UNRESTRICTED_ROLE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_USER_SUBSCRIPTION`
--

DROP TABLE IF EXISTS `AP_USER_SUBSCRIPTION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_USER_SUBSCRIPTION` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TENANT_ID` int NOT NULL,
  `USER_NAME` varchar(100) NOT NULL,
  `SUBSCRIBED_BY` varchar(100) NOT NULL,
  `SUBSCRIBED_TIMESTAMP` timestamp NOT NULL,
  `UNSUBSCRIBED` tinyint(1) NOT NULL DEFAULT '0',
  `UNSUBSCRIBED_BY` varchar(100) DEFAULT NULL,
  `UNSUBSCRIBED_TIMESTAMP` timestamp NULL DEFAULT NULL,
  `AP_APP_RELEASE_ID` int NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_AP_USER_SUBSCRIPTION_AP_APP_RELEASE1_idx` (`AP_APP_RELEASE_ID`),
  CONSTRAINT `fk_AP_USER_SUBSCRIPTION_AP_APP_RELEASE1` FOREIGN KEY (`AP_APP_RELEASE_ID`) REFERENCES `AP_APP_RELEASE` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_USER_SUBSCRIPTION`
--

LOCK TABLES `AP_USER_SUBSCRIPTION` WRITE;
/*!40000 ALTER TABLE `AP_USER_SUBSCRIPTION` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_USER_SUBSCRIPTION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_VPP_ASSOCIATION`
--

DROP TABLE IF EXISTS `AP_VPP_ASSOCIATION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_VPP_ASSOCIATION` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ASSET_ID` int DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  `TENANT_ID` int NOT NULL,
  `ASSOCIATION_TYPE` varchar(255) NOT NULL,
  `PRICING_PARAMS` varchar(255) DEFAULT NULL,
  `CREATED_TIME` bigint DEFAULT NULL,
  `LAST_UPDATED_TIME` bigint DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `AP_VPP_ASSETS_fk` (`ASSET_ID`),
  KEY `AP_VPP_VPP_USER_fk` (`USER_ID`),
  CONSTRAINT `AP_VPP_ASSETS_fk` FOREIGN KEY (`ASSET_ID`) REFERENCES `AP_ASSETS` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `AP_VPP_VPP_USER_fk` FOREIGN KEY (`USER_ID`) REFERENCES `AP_VPP_USER` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_VPP_ASSOCIATION`
--

LOCK TABLES `AP_VPP_ASSOCIATION` WRITE;
/*!40000 ALTER TABLE `AP_VPP_ASSOCIATION` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_VPP_ASSOCIATION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AP_VPP_USER`
--

DROP TABLE IF EXISTS `AP_VPP_USER`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `AP_VPP_USER` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CLIENT_USER_ID` varchar(255) DEFAULT NULL,
  `DM_USERNAME` varchar(255) NOT NULL,
  `TENANT_ID` int NOT NULL,
  `EMAIL` varchar(255) DEFAULT NULL,
  `INVITE_CODE` varchar(255) DEFAULT NULL,
  `STATUS` varchar(255) DEFAULT NULL,
  `CREATED_TIME` bigint DEFAULT NULL,
  `LAST_UPDATED_TIME` bigint DEFAULT NULL,
  `MANAGED_ID` varchar(255) DEFAULT NULL,
  `TEMP_PASSWORD` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AP_VPP_USER`
--

LOCK TABLES `AP_VPP_USER` WRITE;
/*!40000 ALTER TABLE `AP_VPP_USER` DISABLE KEYS */;
/*!40000 ALTER TABLE `AP_VPP_USER` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-09-24 18:06:49
